/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.sa;

import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.schedops.HMCScheduler;
import com.ibm.hwmca.fw.schedops.Schedule;
import com.ibm.hwmca.fw.schedops.ScheduledOperation;
import com.ibm.hwmca.fw.schedops.SchedulerException;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptor;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorData;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.sa.ESAXmitServiceInfoSchedulable;
import com.ibm.hwmca.p.sa.ServiceAgentAttr;
import com.ibm.hwmca.p.sa.ServiceAgentUtils;
import com.ibm.hwmca.p.sa.XMITServiceInfoImmedPanelBean;
import com.ibm.hwmca.p.sa.XMITServiceInfoPanelBean;
import com.ibm.hwmca.p.sa.XMITServiceInfoSchedPanelBean;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class XmitServiceInfoTasklet
extends PanelTasklet
implements ServiceAgentAttr {
    private static final String TRACE_MASKT = "ESA    T";
    private static final String TRACE_MASKF = "ESA    F";
    private static final String TRACE_MASKD = "ESA    D";
    private PanelHandler mainPanelHandler;
    private PanelHandler currentPanel;

    public XmitServiceInfoTasklet() {
        this.currentPanel = this.mainPanelHandler = new PanelHandler(){

            public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
                if (request.isDisposed() || request.isCanceled()) {
                    Trace.trace("ESA__  F", "Terminating the task");
                    response.terminate();
                } else {
                    TaskActionEvent event = (TaskActionEvent)request.getData("event");
                    String elementName = event.getElementName();
                    Trace.trace(XmitServiceInfoTasklet.TRACE_MASKF, "XmitServiceInfoTasklet: " + event);
                    Trace.trace(XmitServiceInfoTasklet.TRACE_MASKF, "           elementName: " + elementName);
                    if (elementName.endsWith("UpdateButton")) {
                        XMITServiceInfoSchedPanelBean siPB = (XMITServiceInfoSchedPanelBean)request.getData("bean");
                        Trace.trace(XmitServiceInfoTasklet.TRACE_MASKF, "<--> Got an UpdateButton: Frequency=" + siPB.getFrequency());
                        Trace.trace(XmitServiceInfoTasklet.TRACE_MASKF, "Frequency=" + siPB.getFrequency());
                        ServiceAgentUtils.setExecutionFrequency(siPB.getFrequency());
                        int freq = siPB.getFrequency();
                        Calendar cal = siPB.getTime();
                        Date date = cal.getTime();
                        long ExecutionTimeOfDay = date.getTime();
                        ServiceAgentUtils.setExecutionTimeOfDay(ExecutionTimeOfDay);
                        try {
                            Object schedulable = null;
                            XmitServiceInfoTasklet.this.removeScheduledOps();
                            Trace.trace(XmitServiceInfoTasklet.TRACE_MASKD, "New Schedulable : Service Agent SchedOps");
                            Trace.trace(XmitServiceInfoTasklet.TRACE_MASKF, "Start date to be scheduled = " + date.getTime());
                            Schedule schedule = new Schedule(date, 1200000L, -1L, (long)freq * 86400000L);
                            ESAXmitServiceInfoSchedulable operation = new ESAXmitServiceInfoSchedulable();
                            HMC target = HMC.getHMC();
                            Trace.trace(XmitServiceInfoTasklet.TRACE_MASKF, "ScheduledOperation options: Scheduled");
                            ScheduledOperation schedop = new ScheduledOperation(target, operation, schedule, "Scheduled");
                            target.getScheduler().addScheduledOperation(schedop);
                        }
                        catch (Throwable t) {
                            Trace.trace(XmitServiceInfoTasklet.TRACE_MASKF, "caught exception " + t);
                        }
                        XmitServiceInfoTasklet.this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.p.sa.res.ServiceAgent", "ESA.title"), new MessageText("com.ibm.hwmca.p.sa.res.ServiceAgent", "ESA0000F"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{new LocalizableText("com.ibm.hwmca.p.sa.res.ServiceAgent", "Ok.button")});
                        response.noAction();
                    } else if (elementName.endsWith("SendButton")) {
                        Trace.trace(XmitServiceInfoTasklet.TRACE_MASKF, "<--> Got SendButton");
                        try {
                            Object schedulable = null;
                            Trace.trace(XmitServiceInfoTasklet.TRACE_MASKD, "Start Service Agent SchedOps");
                            Calendar now = Calendar.getInstance();
                            Schedule schedule = new Schedule(now.getTime(), 1200000L, 1L, 1L);
                            ESAXmitServiceInfoSchedulable operation = new ESAXmitServiceInfoSchedulable();
                            HMC target = HMC.getHMC();
                            ScheduledOperation schedop = new ScheduledOperation(target, operation, schedule, "Immediate");
                            target.getScheduler().addScheduledOperation(schedop);
                        }
                        catch (Throwable t) {
                            Trace.trace(XmitServiceInfoTasklet.TRACE_MASKF, "caught exception " + t);
                        }
                        XmitServiceInfoTasklet.this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.p.sa.res.ServiceAgent", "ESA.title"), new MessageText("com.ibm.hwmca.p.sa.res.ServiceAgent", "ESA0000E"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{new LocalizableText("com.ibm.hwmca.p.sa.res.ServiceAgent", "Ok.button")});
                        response.noAction();
                    } else {
                        response.noAction();
                    }
                }
            }
        };
        Trace.trace(TRACE_MASKT, "<--> XmitServiceInfoTasklet.init");
    }

    private static void setControls(XMITServiceInfoSchedPanelBean siPB) {
    }

    public void logException(Throwable throwable) {
    }

    public void service(PanelTaskletRequest taskletRequest, PanelTaskletResponse taskletResponse) throws TaskletException {
        if (taskletRequest.isInitialRequest()) {
            int RSFSetting = ServiceAgentUtils.ESACheckRSF();
            if (RSFSetting == 1) {
                XMITServiceInfoSchedPanelBean siPB = new XMITServiceInfoSchedPanelBean();
                long ExecutionTimeOfDay = ServiceAgentUtils.getExecutionTimeOfDay();
                Calendar cal = Calendar.getInstance();
                cal.setTime(new Date(ExecutionTimeOfDay));
                siPB.setTime(cal);
                siPB.setFrequency(ServiceAgentUtils.getExecutionFrequency());
                Trace.trace(TRACE_MASKF, "siPB.getFrequency: " + siPB.getFrequency());
                XmitServiceInfoTasklet.setControls(siPB);
                taskletResponse.openModalChild(new DisplayAreaDescriptorData("com.ibm.hwmca.p.sa.res.ServiceAgent", "XMITServiceInfo", new XMITServiceInfoPanelBean(), null, "MainFrame"), new DisplayAreaDescriptor[]{new DisplayAreaDescriptorData("com.ibm.hwmca.p.sa.res.ServiceAgent", "XMITServiceInfoImmediate", new XMITServiceInfoImmedPanelBean(), null, "XMITImmed", "MountPoint"), new DisplayAreaDescriptorData("com.ibm.hwmca.p.sa.res.ServiceAgent", "XMITServiceInfoScheduled", siPB, null, "XMITSched", "MountPoint")});
            } else {
                String messageID = RSFSetting == 2 ? "ESA00004" : (RSFSetting == 3 ? "ESA00005" : (RSFSetting == 4 ? "ESA00006" : "ESA00007"));
                this.showMessageBox(true, new LocalizableText("com.ibm.hwmca.p.sa.res.ServiceAgent", "ESA.title"), new MessageText("com.ibm.hwmca.p.sa.res.ServiceAgent", messageID), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{new LocalizableText("com.ibm.hwmca.p.sa.res.ServiceAgent", "Ok.button")});
                taskletResponse.terminate();
            }
        } else {
            this.currentPanel.service(taskletRequest, taskletResponse);
        }
    }

    private void removeScheduledOps() {
        Trace.trace(TRACE_MASKT, "--> removeScheduledOps()");
        try {
            HMCScheduler scheduler = HMCScheduler.getHMCScheduler();
            ESAXmitServiceInfoSchedulable operation = new ESAXmitServiceInfoSchedulable();
            HMC target = HMC.getHMC();
            List listOfScheduledOps = scheduler.getScheduledOperations(target, operation);
            int size = listOfScheduledOps.size();
            Trace.trace(TRACE_MASKF, "number of scheduled ops to review: " + size);
            int ix = 0;
            while (ix < size) {
                ScheduledOperation so;
                String xmitParms;
                if (listOfScheduledOps.get(ix) != null && (xmitParms = (String)(so = (ScheduledOperation)listOfScheduledOps.get(ix)).getOperationParameters()) != null && xmitParms.equals("Scheduled")) {
                    Trace.trace(TRACE_MASKF, "Found scheduled event to remove: Scheduled");
                    try {
                        scheduler.removeScheduledOperation(so);
                    }
                    catch (SchedulerException e) {
                        Trace.trace(TRACE_MASKF, "caught OperationRemoveException " + e);
                    }
                }
                ++ix;
            }
        }
        catch (Throwable t) {
            Trace.trace(TRACE_MASKF, "caught exception " + t);
        }
        Trace.trace(TRACE_MASKT, "<-- removeScheduledOps()");
    }

    static interface PanelHandler {
        public void service(PanelTaskletRequest var1, PanelTaskletResponse var2) throws TaskletException;
    }
}

